uniform sampler2D texture0;
uniform sampler2D texture1;


varying vec4 gl_TexCoord[];
uniform vec2 u_WindowSize;
uniform vec2 textureSize0;

uniform float u_Elapsed;
#define iResolution u_WindowSize


varying lowp vec3 v_fragmentColor;
varying lowp vec2 v_texCoord;


#define NUM_LIGHTS 12


void main()
{
    vec2 allLightsPosition[NUM_LIGHTS];
    allLightsPosition[0] = vec2 (0.5,0.5);      //top fire
    allLightsPosition[1] = vec2 (0.38,0.65);    //left fire
    allLightsPosition[2] = vec2 (0.6,0.65);     //right fire
    allLightsPosition[3] = vec2 (0.3,0.65);     //tree

    allLightsPosition[4] = vec2 (0.5,0.65);     //firemiddle
    allLightsPosition[5] = vec2 (0.38,0.95);    //left fire - reflect
    allLightsPosition[6] = vec2 (0.6,0.95);     //right fire - reflect
    allLightsPosition[7] = vec2 (0.1,0.3);      //left wall lamp
    allLightsPosition[8] = vec2 (0.28,0.2);      //top lamp 1
    allLightsPosition[9] = vec2 (0.68,0.2);      //top lamp 2
    allLightsPosition[10] = vec2 (0.5,0.15);      //top lamp 3 (middle)
    allLightsPosition[11] = vec2 (0.5,0.95);      //firemiddle (reflect)



    vec4 allLightsColor[NUM_LIGHTS];
    allLightsColor[0] = vec4(1.0 , 1.0, 0.8, 1.0);
    allLightsColor[1] = vec4(1.0 , 1.0, 0.8, 1.0);
    allLightsColor[2] = vec4(1.0 , 1.0, 0.8, 1.0);
    allLightsColor[3] = vec4(1.0 , 1.0, 0.8, 1.0);

    allLightsColor[4] = vec4(1.0 , 1.0, 0.8, 1.0);
    allLightsColor[5] = vec4(1.0 , 1.0, 0.8, 1.0);
    allLightsColor[6] = vec4(1.0 , 1.0, 0.8, 1.0);
    allLightsColor[7] = vec4(0.8 , 0.8, 1.0, 1.); //0: no varying intensity
    allLightsColor[8] = vec4(0.8 , 0.8, 1.0, 1.);
    allLightsColor[9] = vec4(0.8 , 0.8, 1.0, 1.);
    allLightsColor[10] = vec4(0.8 , 0.8, 1.0, 1.);
    allLightsColor[11] = vec4(1.0 , 1.0, 0.8, 1.0);
    
    float allLightsIntensity[NUM_LIGHTS];
    allLightsIntensity[0] = 0.35;
    allLightsIntensity[1] = 0.45;
    allLightsIntensity[2] = 0.55;
    allLightsIntensity[3] = 0.25;
    
    allLightsIntensity[4] = 0.;//0.25;
    allLightsIntensity[5] = 0.35;
    allLightsIntensity[6] = 0.35;
    allLightsIntensity[7] = 0.85;
    allLightsIntensity[8] = 0.85;
    allLightsIntensity[9] = 0.85;
    allLightsIntensity[10] = 0.25;
    allLightsIntensity[11] = 0.35;

    vec3 FinalColor = vec3(0.);

    int i;
    for (i=0; i<NUM_LIGHTS; ++i)
    {
        vec2 u_lightPosition = allLightsPosition[i];
        vec4 LightColor = allLightsColor[i];
        float u_lightIntensity = allLightsIntensity[i] + (allLightsColor[i].a * (abs(sin(u_Elapsed*6.) / 20.)) );
        vec3 u_lightFallOff = vec3(.315,3.215,20.703);

        vec4 AmbientColor = vec4(0.085, 0.085, 0.10, 0.8);
        vec4 DiffuseColor = texture2D(texture0, gl_TexCoord[0].xy);
        vec3 NormalMap = texture2D(texture1, gl_TexCoord[0].xy).rgb;


         vec3 LightDir = vec3(u_lightPosition.xy - (gl_FragCoord.xy / u_WindowSize.xy), 0.085);
         LightDir.x *= u_WindowSize.x / u_WindowSize.y;

        vec2 position = (gl_FragCoord.xy / u_WindowSize.xy) - u_lightPosition;
        float len = length(LightDir);
        vec3 N = normalize(NormalMap*2.0   - 1.0);
        vec3 L = normalize(LightDir);
   
        vec3 Diffuse = (LightColor.rgb * LightColor.a)  * max(dot(N, L), 0.0);
        vec3 Ambient = AmbientColor.rgb * AmbientColor.a;
        float Attenuation = 1.0 / ( u_lightFallOff.x + (u_lightFallOff.y*len) + (u_lightFallOff.z*len*len) );
    
        vec3 Intensity = Ambient + Diffuse * Attenuation * u_lightIntensity ;
        
        FinalColor += DiffuseColor.rgb * Intensity ;

    }

     gl_FragColor =   vec4(gl_Color.rgb * FinalColor.rgb, 1.0);

}